<?php

namespace App\Services;

use App\Models\Prescription;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;

class PrescriptionPdfService
{
    public function generate(Prescription $prescription): string
    {
        $prescription->load(['patient', 'doctor', 'items', 'appointment.vitals']);

        $data = [
            'prescription' => $prescription,
            'doctor' => $prescription->doctor,
            'patient' => $prescription->patient,
            'items' => $prescription->items,
            'vitals' => $prescription->appointment->vitals,
            'appointment' => $prescription->appointment,
            'letterhead' => $prescription->doctor->letterhead_path 
                ? Storage::disk('public')->path($prescription->doctor->letterhead_path) 
                : null,
            'stamp' => $prescription->doctor->stamp_path 
                ? Storage::disk('public')->path($prescription->doctor->stamp_path) 
                : null,
            'signature' => $prescription->doctor->signature_path 
                ? Storage::disk('public')->path($prescription->doctor->signature_path) 
                : null,
        ];

        $pdf = Pdf::loadView('prescriptions.pdf', $data);
        $filename = 'prescriptions/' . $prescription->prescription_number . '.pdf';
        
        Storage::disk('public')->put($filename, $pdf->output());

        return $filename;
    }
}

